/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
CSkeleton cskel;
Flt       blend; // blending value (0..1)
Bool      walk ; // if want to walk
/******************************************************************************/
void InitPre()
{
   App.name="Animation Blending";
   App.flag=APP_MS_EXCLUSIVE;
   PakAdd("../data/engine.pak");
}
/******************************************************************************/
Bool Init()
{
   Text_ds.color =BLACK;
   Text_ds.shadow=0;

   Cam.dist=2;
   Cam.yaw =PI;

   cskel.create("../data/obj/chr/skeleton/0.skel",1.7); // create controlled skeleton from skel file, with 1.7 meter height
   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(0.1,10,CAMH_ROT|CAMH_ZOOM);
   if(Kb.bp(KB_SPACE))walk^=1; // change 'walk' when space pressed

   // adjust blend value
   if(walk)
   {
      blend+=Tm.d*2;
      if(blend>1)blend=1;
   }else
   {
      blend-=Tm.d*2;
      if(blend<0)blend=0;
   }

   // set animations
   {   
      cskel.clear  (); // clear controlled skeleton animation
      cskel.animate("../data/anim/walk.anim",Tm.time(),   blend); // animate with "walk" animation, current time position and '  blend' blending weight
      cskel.animate("../data/anim/run.anim" ,Tm.time(), 1-blend); // animate with "walk" animation, current time position and '1-blend' blending weight
      cskel.updateMatrix(MatrixIdentity).updateVelocities();      // update controlled skeleton animation and velocities
   }

   return true;
}
/******************************************************************************/
void Draw()
{
   D.clear(WHITE);
   LightDir(1,Vec(0,0,-1)).set();

   // render
   {
      Meshs("../data/obj/chr/skeleton/0.mesh")->draw(cskel); // get mesh from cache and render it with controlled skeleton

      if(Kb.ctrl) // when control pressed
      {
         MatrixSet();     // restore default matrix
         cskel.draw(RED); // draw controlled skeleton
      }
   }

   D.text(0,0.8,S+"Press space to toggle blending (Walk: "+walk+", Blend: "+blend+')');
}
/******************************************************************************/
